// pages/modifyUser/index.js
import {
  request
} from "../../utils/request.js"
Page({

  /**
   * 页面的初始数据
   */
  data: {
    item: {},
    label: "",
    password: "",
    remark: "",
    isAdmin: false,
    isModify: false
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad({
    item
  }) {
    wx.setNavigationBarTitle({
      title: item ? "编辑账号" : "新建账号"
    })
    if (item) {
      const data1 = JSON.parse(item);
      this.setData({
        item: data1,
        isModify: true,
        label: data1.label,
        remark: data1.remark,
        isAdmin: data1.isAdmin,
      })

    } else {
      this.setData({
        item: {},
        isModify: false,
        label: "",
        remark: "",
        isAdmin: false,
        password: "",
      })
    }
  },
  handleClick() {
    request(this.data.isModify ? "user/update" : "user/add", this.data.isModify ? {
      label: this.data.label,
      remark: this.data.remark,
      isAdmin: this.data.isAdmin,
      id: this.data.item.id,

    } : {
      label: this.data.label,
      remark: this.data.remark,
      isAdmin: this.data.isAdmin,
      password: this.data.password,

    }).then(res => {
      wx.navigateBack()
    })
  }
})