const cloud = require('wx-server-sdk')
cloud.init({
  env: cloud.DYNAMIC_CURRENT_ENV
})

exports.main = async (event) => {
  const {
    name,
    type,
    files,
    username
  } = event.data

  try {
    const db = cloud.database();
    await db.collection('contract').add({
      data: {
        username,
        name,
        type,
        createDate: new Date(),
        fileIds: files,
      }
    })
    return {
      success: true
    }
  } catch (err) {
    return {
      success: false,
      msg: err.message
    }
  }
}