// pages/login/login.js
import {
  request
} from "../../utils/request.js"
Page({

  /**
   * 页面的初始数据
   */
  data: {
    username: "",
    password: "",
    showPassword: false
  },
  login() {
    if (this.data.username.trim() === "") {
      wx.showToast({
        title: '账号不能为空',
        icon: "none"
      })
      return
    }
    if (this.data.password.trim() === "") {
      wx.showToast({
        title: '密码不能为空',
        icon: "none"
      })
      return
    }
    request("user/login", {
      username: this.data.username,
      password: this.data.password
    }).then(result => {
      getApp().globalData.userInfo = result.userInfo
      const pages = getCurrentPages()
      if (pages.length > 1) {
        wx.navigateBack()
      } else {
        wx.switchTab({
          url: '/pages/user-center/index',
        })
      }
    })
  },
  iconClick() {
    this.setData({
      showPassword: !this.data.showPassword
    })
  }
})