const createContract = require('./createContract/index');
const getContract = require('./getContract/index');
const login = require('./login/index');
const getUser = require('./getUser/index');
const updateContract = require('./updateContract/index');
const deleteContract = require('./deleteContract/index');
const addUser = require('./addUser/index');
const deleteUser = require('./deleteUser/index');
const updateUser = require('./updateUser/index');

// 云函数入口函数
exports.main = async (event, context) => {
  switch (event.type) {
    case 'getContract':
      return await getContract.main(event, context);
    case 'createContract':
      return await createContract.main(event, context);
    case 'updateContract':
      return await updateContract.main(event, context);
    case 'deleteContract':
      return await deleteContract.main(event, context);
    case 'login':
      return await login.main(event, context);
    case 'getUser':
      return await getUser.main(event, context);
    case 'addUser':
      return await addUser.main(event, context);
    case 'deleteUser':
      return await deleteUser.main(event, context);
    case 'updateUser':
      return await updateUser.main(event, context);
  }
};