// pages/contract/index.js
import ActionSheet, {
  ActionSheetTheme
} from 'tdesign-miniprogram/action-sheet/index';
import Dialog from 'tdesign-miniprogram/dialog/index';
import {
  request
} from "../../utils/request.js"
const dayjs = require("dayjs");
let tempitem;
Page({

  /**
   * 页面的初始数据
   */
  data: {
    enable: false,
    list: [],
    isAdmin: false
  },
  onShow() {
    const userInfo = getApp().globalData.userInfo
    this.setData({
      username: userInfo.username,
      isAdmin: userInfo.isAdmin
    })
    this.onRefresh();
  },
  onRefresh() {
    this.setData({
      enable: true
    });
    request("getContract", {}, {
      loadingMask: false,
      needUsername: true
    }).then(result => {
      const list = result.result.data || []
      this.setData({
        list: list.map(v => ({
          text: v.name,
          createDate: dayjs(v.createDate).format('YYYY-MM-DD HH:mm:ss'),
          type: v.type === 0 ? "pdf" : "图片",
          id: v._id,
          fileIds: v.fileIds,
          username:v.username
        })),
      });
    }).finally(() => {
      this.setData({
        enable: false
      })
    })
    // wx.cloud.callFunction({
    //   name: "test1",
    //   data: {
    //     type: "getContract",
    //     data: {
    //       username: getApp().globalData.userInfo.username
    //     }
    //   },
    //   success: (res) => {
    //     this.setData({
    //       list: res.result.result.data.map(v => ({
    //         text: v.name,
    //         createDate: dayjs(v.createDate).format('YYYY-MM-DD HH:mm:ss'),
    //         type: v.type === 0 ? "pdf" : "图片",
    //         id: v._id,
    //         fileIds: v.fileIds
    //       })),
    //       enable: false
    //     });
    //   },
    //   error: (err) => {
    //     this.setData({
    //       enable: false
    //     })
    //   }

    // })
  },
  handleAction() {
    wx.navigateTo({
      url: '/pages/addContract/index',
    })
  },
  openFile(item) {
    const {
      type,
      fileIds
    } = item
    console.log(type)
    if (type === "pdf") {
      wx.cloud.downloadFile({
        fileID: fileIds[0],
        success(res) {
          if (res.statusCode === 200) {
            wx.openDocument({
              filePath: res.tempFilePath,
              fileType: "pdf"
            })
          }
        }
      })
    } else {
      wx.previewImage({
        urls: fileIds // 需要预览的图片http链接列表
      })
    }
  },
  openAction(e) {
    if (this.data.isAdmin) {
      tempitem = e.target.dataset.item;
      ActionSheet.show(action)
    } else {
      this.openFile(e.target.dataset.item)
    }
  },
  handleSelected(e) {
    const {
      index
    } = e.detail
    console.log(index)
    if (index === 0) {
      //查看
      this.openFile(tempitem)

    } else if (index === 1) {
      //编辑
      wx.navigateTo({
        url: '/pages/updateContract/index?item=' + JSON.stringify(tempitem),
      })
    } else {
      //删除
      const dialogConfig = {
        context: this,
        closeOnOverlayClick: true,
        content: '确定要删除' + tempitem.text + '吗？',
        confirmBtn: '确定',
        cancelBtn: '取消',
      };

      Dialog.confirm(dialogConfig)
        .then(() => {
          request("deleteContract", {
            id: tempitem.id
          }).then(() => {
            this.onRefresh()
          })
        })
        .catch(() => {});
    }

  }
})
const action = {
  theme: ActionSheetTheme.List,
  selector: '#t-action-sheet',
  items: [{
      label: '查看合同',
    },
    {
      label: '编辑合同',
      color: '#0052D9',
    },
    {
      label: '删除合同',
      color: '#e34d59',
    },
  ],
}