const cloud = require('wx-server-sdk')
cloud.init({
  env: cloud.DYNAMIC_CURRENT_ENV
})

exports.main = async (event) => {
  const {
    id
  } = event.data
  const db = cloud.database({
    throwOnNotFound: false
  });
  try {
    const doc = db.collection('contract').doc(id);
    const {
      data
    } = await doc.get()
    doc.remove()
    cloud.deleteFile({
      fileList: data.fileIds
    })
    return {
      success: true,
    }
  } catch (err) {
    return {
      success: false,
      msg: err.message
    }
  }


}