// pages/login/login.js
import {
  request
} from "../../utils/request.js"
Page({

  /**
   * 页面的初始数据
   */
  data: {
    username: "",
    password: ""
  },
  login() {
    if (this.data.username.trim() === "") {
      wx.showToast({
        title: '账号不能为空',
        icon: "none"
      })
      return
    }
    if (this.data.password.trim() === "") {
      wx.showToast({
        title: '密码不能为空',
        icon: "none"
      })
      return
    }
    request("user/login", {
      username: this.data.username,
      password: this.data.password
    }).then(result => {
      getApp().globalData.userInfo = result.userInfo
      const pages = getCurrentPages()
      if (pages.length > 1) {
        wx.navigateBack()
      } else {
        wx.switchTab({
          url: '/pages/user-center/index',
        })
      }
    })
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad(options) {

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage() {

  }
})