// pages/contract-detail/index.js
Page({

  /**
   * 页面的初始数据
   */
  data: {
    imageProps: {
      mode: "aspectFill",
      style: "width:200%"
    }
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad(e) {
    const item = JSON.parse(e.item)
    wx.setNavigationBarTitle({
      title: item.text,
    })
    const l = item.fileIds[0].split("/")

    const pdfname = l[l.length - 1]
    this.setData({
      username: item.username,
      fileIds: item.fileIds,
      name: item.text,
      type: item.type,
      pdfname
    })

  },
  openFile() {
    wx.cloud.downloadFile({
      fileID: this.data.fileIds[0],
      success: function (res) {
        const filePath = res.tempFilePath
        wx.openDocument({
          filePath,
          fileType: "pdf"
        })
      },
      fail: console.log
    })
  },
  imageClick(e) {
    console.log()
    wx.previewImage({
      urls: this.data.fileIds,
      current: this.data.fileIds[e.target.dataset.index]
    })
  }
})