import ActionSheet, {
  ActionSheetTheme
} from 'tdesign-miniprogram/action-sheet/index';
const {
  envList
} = require('../../envList');
const defaultAvatarUrl = 'https://mmbiz.qpic.cn/mmbiz/icTdbqWNOwNRna42FI242Lcia07jQodd2FJGIYQfG0LAJGFxM4FbnQP6yfMxBgJ0F3YRqJCJ1aPAK2dQagdusBZg/0'
// pages/me/index.js
Page({
  /**
   * 页面的初始数据
   */
  data: {
    username: '',
    isAdmin: false,
    showTip: false,
    title: "",
    content: "",
    avatarUrl: defaultAvatarUrl
  },
  onShow() {
    const userInfo = getApp().globalData.userInfo || {}
    this.setData({
      username: userInfo.username,
      isAdmin: userInfo.isAdmin
    })

  },
  onChooseAvatar(e) {
    const {
      avatarUrl
    } = e.detail
    this.setData({
      avatarUrl,
    })
  },
  toLogin() {
    wx.navigateTo({
      url: '/pages/login/index',
    })
  },
  handleSelected() {
    getApp().globalData.userInfo = {}
    this.setData({
      username: '',
      isAdmin: false,
    })
    wx.reLaunch({
      url: '/pages/user-center/index',
    })
  },
  logout() {
    if (this.data.username && this.data.username !== "") {
      ActionSheet.show(basicListOption)
    }
  }
});

const basicListOption = {
  theme: ActionSheetTheme.List,
  selector: '#t-action-sheet',
  items: [{
    label: '退出登录',
  }, ],
};