// pages/addPontract/index.js
Page({

  /**
   * 页面的初始数据
   */
  data: {
    test: {
      size: 'large',
      block: true
    },
    type: 0,
    gridConfig: {
      column: 4,
      width: 160,
      height: 160,
    },
    originFiles: [],
    tempFile: {},
    name: ""
  },
  onChange(e) {
    this.setData({
      originFiles: [],
      tempFile: {},
      type: e.detail.value
    });
  },
  selectPdf() {
    wx.chooseMessageFile({
      count: 1,
      type: 'file',
      extension: ["pdf"],
      success: (res) => {
        this.setData({
          tempFile: res.tempFiles[0]
        })
      }
    })
  },
  openFile() {
    wx.openDocument({
      filePath: this.data.tempFile.path,
      fileType: "pdf"
    })
  },
  handleSuccess(e) {
    const {
      files
    } = e.detail;
    this.setData({
      originFiles: files,
    });
  },
  handleRemove(e) {
    const {
      index
    } = e.detail;
    const {
      originFiles
    } = this.data;
    originFiles.splice(index, 1);
    this.setData({
      originFiles,
    });
  },
  handleDrop(e) {
    const {
      files
    } = e.detail;
    this.setData({
      originFiles: files,
    });
  },
  async createContract() {
    wx.showLoading({
      title: '',
    });
    const username = getApp().globalData.userInfo.username

    if (this.data.type === 0) {
      wx.cloud.uploadFile({
        cloudPath: `contract/${username}/${this.data.tempFile.name}`,
        filePath: this.data.tempFile.path, // 文件路径
        success: res => {
          wx.cloud
            .callFunction({
              name: 'test1',
              data: {
                type: 'createContract',
                data: {
                  username,
                  name: this.data.name,
                  type: this.data.type,
                  files: [res.fileID]

                }

              },
              success(res) {
                wx.navigateBack()

              },
              complete(res) {
                console.log(res)
                wx.hideLoading()
              }
            })
        },
        fail: err => {
          console.log(err)
        }
      })
    }

  }
})