// pages/contract/index.js
const dayjs = require("dayjs");
Page({

  /**
   * 页面的初始数据
   */
  data: {
    enable: false,
    list: []
  },
  onShow() {
    this.onRefresh();
  },
  onRefresh() {
    this.setData({
      enable: true
    });
    wx.cloud.callFunction({
      name: "test1",
      data: {
        type: "getContract",
        data: {
          username: getApp().globalData.userInfo.username
        }
      },
      success: (res) => {
        this.setData({
          list: res.result.result.data.map(v => ({
            text: v.name,
            createDate: dayjs(v.createDate).format('YYYY-MM-DD HH:mm:ss'),
            type: v.type === 0 ? "pdf" : "图片",
            id: v._id,
            fileIds: v.fileIds
          })),
          enable: false
        });
      },
      error: (err) => {
        this.setData({
          enable: false
        })
      }

    })
  },
  handleAction() {
    // ActionSheet.show({
    //   theme: ActionSheetTheme.List,
    //   selector: '#t-action-sheet',
    //   context: this,
    //   description: '选择类型',
    //   items: [{
    //       label: '图片',
    //     },
    //     {
    //       label: 'pdf',
    //     },
    //   ],
    // });
    wx.navigateTo({
      url: '/pages/addContract/index',
    })
  },
  openFile(e) {
    const {
      type,
      fileIds
    } = e.target.dataset.item
    console.log(type)
    if (type === "pdf") {
      wx.cloud.downloadFile({
        fileID: fileIds[0],
        success(res) {
          if (res.statusCode === 200) {
            wx.openDocument({
              filePath: res.tempFilePath,
              fileType: "pdf"
            })
          }
        }
      })
    }
  },
  // handleSelected(e){

  // }
})