// pages/login/login.js
import Toast from 'tdesign-miniprogram/toast/index';
Page({

  /**
   * 页面的初始数据
   */
  data: {
    username: "",
    password: ""
  },
  login() {
    wx.showLoading({
      title: '',
    });
    wx.cloud
      .callFunction({
        name: 'test1',
        data: {
          type: 'login',
          data: {
            username: this.data.username,
            password: this.data.password
          }

        },
        success: (res) => {
          if (res.result.success) {
            getApp().globalData.userInfo = res.result.userInfo
            wx.switchTab({
              url: "/pages/user-center/index"
            })
            // wx.setStorage({
            //   key: "userInfo",
            //   data: res.result.userInfo,
            //   success() {
            //     wx.switchTab({
            //       url: "/pages/user-center/index"
            //     })
            //   }
            // })
          } else {
            Toast({
              context: this,
              selector: '#t-toast',
              message: res.result.msg || res.errMsg,
              theme: 'error',
              direction: 'column',
            });
          }

        },
        error: (res) => {
          Toast({
            context: this,
            selector: '#t-toast',
            message: res.message || res.errMsg,
            theme: 'error',
            direction: 'column',
          });
        },
        complete(res) {
          wx.hideLoading()
        }
      })
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad(options) {

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage() {

  }
})