const {
  envList
} = require('../../envList');
const defaultAvatarUrl = 'https://mmbiz.qpic.cn/mmbiz/icTdbqWNOwNRna42FI242Lcia07jQodd2FJGIYQfG0LAJGFxM4FbnQP6yfMxBgJ0F3YRqJCJ1aPAK2dQagdusBZg/0'
// pages/me/index.js
Page({
  /**
   * 页面的初始数据
   */
  data: {
    username: '',
    isAdmin: false,
    showTip: false,
    title: "",
    content: "",
    avatarUrl: defaultAvatarUrl
  },
  onShow() {
    const userInfo = getApp().globalData.userInfo
    this.setData({
      username: userInfo.username,
      isAdmin: userInfo.isAdmin
    })

  },
  onChooseAvatar(e) {
    const {
      avatarUrl
    } = e.detail
    this.setData({
      avatarUrl,
    })
  },
  toLogin() {
    wx.navigateTo({
      url: '/pages/login/index',
    })
  },
  gotoWxCodePage() {
    wx.navigateTo({
      url: `/pages/exampleDetail/index?envId=${envList?.[0]?.envId}&type=getMiniProgramCode`,
    });
  },
});