const cloud = require('wx-server-sdk')
cloud.init({
  env: cloud.DYNAMIC_CURRENT_ENV
})

exports.main = async (event) => {
  const {
    username
  } = event.data
  const db = cloud.database();
  const _ = db.command
  // 如果云函数所在环境为 abc，则下面的调用就会请求到 abc 环境的数据库
  const isAdmin = await db.collection('user').where({
    username: _.eq(username)
  }).get()
  const result = isAdmin.data[0].isAdmin ? await db.collection('contract').get() : db.collection('contract').where({
    username: _.eq(username)
  }).get()

  return {
    success: true,
    result,
  }
}