// pages/contract/index.js
const dayjs = require("dayjs");
Page({

  /**
   * 页面的初始数据
   */
  data: {
    enable: false,
    list: []
  },
  onShow() {
    this.onRefresh();
  },
  onRefresh() {
    this.setData({
      enable: true
    });
    wx.cloud.callFunction({
      name: "test1",
      data: {
        type: "getContract",
        data: {
          username: getApp().globalData.userInfo.username
        }
      },
      success: (res) => {
        this.setData({
          list: res.result.result.data.map(v => ({
            text: v.name,
            createDate: dayjs(v.createDate).format('YYYY-MM-DD HH:mm:ss'),
            type: v.type === 0 ? "pdf" : "图片",
            id: v._id
          })),
          enable: false
        });
      },
      error: (err) => {
        console.log(err)
        this.setData({
          enable: false
        })
      }

    })
  },
  handleAction() {
    // ActionSheet.show({
    //   theme: ActionSheetTheme.List,
    //   selector: '#t-action-sheet',
    //   context: this,
    //   description: '选择类型',
    //   items: [{
    //       label: '图片',
    //     },
    //     {
    //       label: 'pdf',
    //     },
    //   ],
    // });
    wx.navigateTo({
      url: '/pages/addContract/index',
    })
  },
  // handleSelected(e){

  // }
})